VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Paced Digital Output with KPCI-3140"
   ClientHeight    =   5715
   ClientLeft      =   2370
   ClientTop       =   2520
   ClientWidth     =   6780
   Icon            =   "frmDOBuffer.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   5715
   ScaleWidth      =   6780
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   5040
      TabIndex        =   13
      Top             =   4560
      Width           =   975
   End
   Begin VB.Frame Frame1 
      Caption         =   "Internal Clock Rate (Hz)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1935
      Left            =   2760
      TabIndex        =   8
      Top             =   1440
      Width           =   2895
      Begin VB.OptionButton optRate 
         Caption         =   "200 KHz"
         Height          =   255
         Index           =   3
         Left            =   360
         TabIndex        =   12
         Top             =   1440
         Width           =   1935
      End
      Begin VB.OptionButton optRate 
         Caption         =   "100 KHz"
         Height          =   255
         Index           =   2
         Left            =   360
         TabIndex        =   11
         Top             =   1080
         Width           =   1935
      End
      Begin VB.OptionButton optRate 
         Caption         =   "1 KHz"
         Height          =   255
         Index           =   1
         Left            =   360
         TabIndex        =   10
         Top             =   720
         Value           =   -1  'True
         Width           =   1935
      End
      Begin VB.OptionButton optRate 
         Caption         =   "200 Hz"
         Height          =   255
         Index           =   0
         Left            =   360
         TabIndex        =   9
         Top             =   360
         Width           =   1935
      End
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2760
      TabIndex        =   5
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   840
      Width           =   615
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Open Driver"
      Height          =   375
      Left            =   480
      TabIndex        =   4
      Top             =   840
      Width           =   1935
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop DO Task"
      Enabled         =   0   'False
      Height          =   375
      Left            =   480
      TabIndex        =   3
      Top             =   2400
      Width           =   1935
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start Buffered DO task"
      Enabled         =   0   'False
      Height          =   375
      Left            =   480
      TabIndex        =   0
      Top             =   1680
      Width           =   1935
   End
   Begin DlsrLib.DriverLINXSR SRDO 
      Left            =   4440
      Top             =   360
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label1 
      Caption         =   "Witness the digital lines of DIO channels 0 and 1 changing state."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   480
      TabIndex        =   14
      Top             =   4800
      Width           =   3615
   End
   Begin VB.Label Label3 
      Caption         =   "Device Number:"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2760
      TabIndex        =   7
      Top             =   600
      Width           =   1215
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   435
      Left            =   360
      TabIndex        =   6
      Top             =   120
      Width           =   2295
   End
   Begin VB.Label lblDOStatus 
      BackColor       =   &H8000000E&
      Caption         =   "DO Status"
      Height          =   255
      Left            =   480
      TabIndex        =   2
      Top             =   4200
      Width           =   3015
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Caption         =   "Status"
      Height          =   255
      Left            =   480
      TabIndex        =   1
      Top             =   3720
      Width           =   3015
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' VB6.0 application
' tested with KPCI-3140
' using 3140-850A02 driver revision in Win2KSP1
'
' Goal of this application:  show how to do a WORD (16 bit) bit stream.
' Unlike the digital I/O boards that have only external clock feature,
' the KPCI-3140 has internal timebase for pacing the reading or writing
' rate for the digital I/O channels.
' All four channels could be written/read even though this example shows only
' the first two.
Dim doBuffer() As Byte  ' declare an array that will be used for the data to be written
Dim bufSize As Single
Dim rate As Single   ' variable for the update rate (in Hz)

Private Sub cmdExit_Click()
' stop any task that could be active
With SRDO
.Req_op = DL_STOP
.Refresh
End With
' unload the driver
SRDO.Req_DLL_name = ""
End
End Sub

Private Sub cmdInit_Click()
With SRDO
.Req_DLL_name = "kpci3140"
.Req_device = CInt(devNum.Text)
.Req_op = DL_INITIALIZE
.Req_mode = DL_OTHER
.Req_subsystem = DL_DEVICE
.Refresh
End With
lblStatus.Caption = SRDO.Message

If SRDO.Res_result = DL_NoErr Then
' by default, the digital channels are input channels.  Must
' config them for output direction
ConfigDigitalChannelForOutput SRDO, 0
ConfigDigitalChannelForOutput SRDO, 1
' enable other buttons
cmdStart.Enabled = True
cmdInit.Enabled = False
' set rate equal to number that corresponds to our default rate
' setting from the option buttons
rate = 1000  ' 1KHz
End If
Form1.SetFocus  ' set focus back to our form
End Sub

Private Sub cmdStart_Click()
' reset the DO subsystem
With SRDO
.Req_op = DL_INITIALIZE
.Req_mode = DL_OTHER
.Req_subsystem = DL_DO
.Sel_buf_N = 0  ' needed to reset the buffers to zero
.Refresh
End With

' lower limit is determined by timebase divided by 24bit counter
' Internal1 time base for KPCI-3140 is 40MHz
' Speed can be no less than 2.3 Hz
'
'
' upper rate limit for paced DO is about 250KHz empirically determined
' on this test machine:  P3-933MHz

' set our bufsize equal to a fraction of the rate
bufSize = rate \ 10 ' buffer size is equal to 100 msec worth of data

Dim i As Single
ReDim doBuffer(bufSize) As Byte
Dim dummy As Long


' load the buffer with DO values
For i = 0 To bufSize - 1 Step 4
doBuffer(i) = &HFF   ' loads buffer with toggled values
doBuffer(i + 1) = &HFF
doBuffer(i + 2) = 0
doBuffer(i + 3) = 0
' for the two 8bit ports, the above will load a 0,0, 255,255, 0,0, 255,255, 0,0, etc
' each bit will toggle at each clock update
Next i
With SRDO
.Req_op = DL_START
.Req_mode = DL_INTERRUPT
.Req_subsystem = DL_DO
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_COMMAND
' timing information
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = DL_DEFAULTTIMER  ' default for DO subsytem of KPCI-3140 is chan 8
.Evt_Tim_rateClock = DL_INTERNAL1  ' 40MHz timebase
.Evt_Tim_rateGate = DL_DISABLED
.Evt_Tim_rateMode = DL_RATEGEN
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / rate)
' channel and number of samples info
.Sel_buf_N = 100
.Sel_buf_samples = bufSize
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled messages
.Sel_chan_N = 2  ' a start channel and a stop channel = 2 channels
.Sel_chan_format = DL_tNATIVE
.Sel_chan_start = 0
'.Sel_chan_startGainCode = 0  ' for DO, not really relevent
.Sel_chan_stop = 1
'.Sel_chan_stopGainCode = 0
.Sel_chan_simultaneousScan = True  ' write all channels at each clock tic
' move the doBuffer array to the memory buffers
For i = 0 To 99
dummy = .VBArrayBufferXfer(i, doBuffer, DL_VBArrayToBuffer)
Next i
'.Req_op_edit = True
'.Refresh
.Refresh  ' write the buffer
End With

' witness the DO change of state at TB34 and TB44 on STP-3140

If SRDO.Res_result = DL_NoErr Then
lblDOStatus.Caption = "Starting DO task....."
cmdStop.Enabled = True
cmdStart.Enabled = False
Frame1.Enabled = False  ' do not allow the clock rates to be selected while task is active
Else
lblDOStatus.Caption = SRDO.Message
End If
lblStatus.Caption = SRDO.Message
End Sub

Private Sub cmdStop_Click()
With SRDO
.Req_op = DL_STOP
.Refresh
End With

cmdStop.Enabled = False
cmdStart.Enabled = True
Frame1.Enabled = True  ' allow new update rates to be programmed
End Sub

Private Sub Form_Load()
Dim i As Integer
' populate combo box with legal device numbers for DriverLINX, e.g., 0...5
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
devNum.ListIndex = 0 ' set it equal to first entry
End Sub

Private Sub Form_Unload(Cancel As Integer)
' unload the driver
SRDO.Req_DLL_name = ""
End Sub


Private Sub optRate_Click(Index As Integer)
Select Case Index
Case 0
rate = 200
Case 1
rate = 1000
Case 2
rate = 100000
Case 3
rate = 200000
End Select
End Sub

Private Sub SRDO_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
lblDOStatus.Caption = " buffer " & Str(bufIndex) & " has been written...."
' you could "re-fill" the buffers here to write data dynamically
End Sub

Private Sub SRDO_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
MsgBox "Clock Rate too fast for the size/number of buffers....", vbCritical
Beep
Beep
End Sub

Private Sub SRDO_ServiceDone(task As Integer, device As Integer, subsystem As Integer, mode As Integer)
lblStatus.Caption = " Buffered DO task is done. "
End Sub

Private Sub ConfigDigitalChannelForOutput(SRcontrol As Control, chan As Integer)
' config digital channel 0 for output direction
With SRcontrol
.Req_subsystem = DL_DO  ' the subsystem to assign the channel to
.Req_mode = DL_OTHER
.Req_op = DL_CONFIGURE  ' it is a configuration type operation
.Evt_Tim_type = DL_DIOSETUP
.Evt_Tim_dioChannel = chan   ' which channel to configure as Output
.Evt_Tim_dioMode = DL_DIO_BASIC
.Evt_Str_type = DL_NULLEVENT
.Evt_Stp_type = DL_NULLEVENT
.Sel_chan_N = 0
.Refresh                      ' carry out the request
End With
End Sub
